package cn.com.duiba.live.supplier.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.supplier.center.api.dto.DuibaLiveSupplierDto;
import cn.com.duiba.live.supplier.center.api.dto.DuibaLiveSupplierSimpleDto;
import cn.com.duiba.live.supplier.center.api.dto.DuibaLiveSupplierUpdateDto;
import cn.com.duiba.live.supplier.center.api.params.SupplierPageParam;
import cn.com.duiba.live.supplier.center.api.dto.DuibaLiveSupplierPageDto;

import java.util.List;

/**
 * @date:2022/1/7 11:38
 * @author:zhaozhanghai
 * @Description: 供应商服务
 */
@AdvancedFeignClient
public interface RemoteDuibaLiveSupplierService {


    DuibaLiveSupplierPageDto page(SupplierPageParam supplierPageParam);

    DuibaLiveSupplierDto getById(Long supplierId);

    Long save(DuibaLiveSupplierDto duibaLiveSupplierDto) throws BizException;

    int update(DuibaLiveSupplierUpdateDto duibaLiveSupplierUpdateDto) throws BizException;

    /**
     * 根据登陆账号获取供应商信息 登陆账号唯一性
     * @param loginAccount
     * @return
     */
    DuibaLiveSupplierDto getByLoginAccount(String loginAccount);

    /**
     * 开启停用供应商 并同步处理供应商商品上架/下架处理
     *  @param supplierId
     * @param status 0关闭 1开启
     * @return
     */
    Boolean setSupplierState(Long supplierId,Integer status) throws BizException;

    /**
     * 根据供应商名模糊搜索
     * @param supplierName
     * @return
     */
    List<DuibaLiveSupplierSimpleDto> listByLikeName(String supplierName);


    List<DuibaLiveSupplierDto> listBySupplierIds(List<Long> distributorIds);





}
