package cn.com.duiba.live.supplier.center.api.remoteservice.sku;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.supplier.center.api.dto.sku.AttributeLibraryDto;

import java.util.List;
import java.util.Map;

/**
 * @author xutao
 */
@AdvancedFeignClient
public interface RemoteDuibaLiveAttributeLibraryService {

    /**
     * 查询所有规格名
     *
     * @return 规格名列表
     */
    List<AttributeLibraryDto> findAllAttributeLibrary();

    /**
     * 查询规格ID列表数据
     *
     * @return 规格名列表
     */
    List<AttributeLibraryDto> findAttributeLibraryByIdList(List<Long> libraryIds);

    /**
     * 根据供应商Id查询所有规格列表
     *
     * @param supplierId 供应商Id
     * @return 规格名列表
     */
    List<AttributeLibraryDto> listBySupplierId(Long supplierId);

    /**
     * 保存规格
     *
     * @param dto 规格详情
     * @return 规格名Id
     */
    Long saveAttributeLibrary(AttributeLibraryDto dto);


    /**
     * 批量保存规格项
     *
     * @param list
     * @return
     * @throws BizException
     */
    Map<String, Long> batchSave(List<AttributeLibraryDto> list) throws BizException;

    List<AttributeLibraryDto> findLibraryBySpec(List<String> specNameList);
}
