/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.live.supplier.center.api.tool.sku;

import cn.com.duiba.live.supplier.center.api.dto.DuibaLiveSupplierGoodsSkuDto;
import cn.com.duiba.live.supplier.center.api.dto.sku.GoodsSkuInfo;
import cn.com.duiba.live.supplier.center.api.dto.sku.SkuAttributeNode;
import cn.com.duiba.live.supplier.center.api.tool.UnitUtils;
import cn.com.duiba.live.supplier.center.api.tool.sku.AbstractSkuResolver;

public class GoodsSkuResolver
extends AbstractSkuResolver<DuibaLiveSupplierGoodsSkuDto, GoodsSkuInfo> {
    @Override
    protected DuibaLiveSupplierGoodsSkuDto toDto(Long appItemId, Long goodsId, String attributeJson, GoodsSkuInfo goodsSkuInfo) {
        DuibaLiveSupplierGoodsSkuDto goodsSku = new DuibaLiveSupplierGoodsSkuDto();
        goodsSku.setSupplierGoodsId(goodsId);
        goodsSku.setAttributeJson(attributeJson);
        goodsSku.setId(this.parseString2Long(goodsSkuInfo.getId()));
        goodsSku.setFacePrice(UnitUtils.transformYuan2Fen(goodsSkuInfo.getFacePrice()));
        goodsSku.setSalePrice(UnitUtils.transformYuan2Fen(goodsSkuInfo.getSalePrice()));
        goodsSku.setCostPrice(UnitUtils.transformYuan2Fen(goodsSkuInfo.getCostPrice()));
        goodsSku.setPopShowPrice(UnitUtils.transformYuan2Fen(goodsSkuInfo.getPopShowPrice()));
        goodsSku.setSuggestMarketPrice(UnitUtils.transformYuan2Fen(goodsSkuInfo.getSuggestMarketPrice()));
        goodsSku.setMerchantCoding(goodsSkuInfo.getMerchantCoding());
        goodsSku.setRemaining(goodsSkuInfo.getRemaining());
        goodsSku.setPreRemaining(goodsSkuInfo.getPreRemaining());
        goodsSku.setImgUrl(goodsSkuInfo.getImgUrl());
        goodsSku.setStockId(this.parseString2Long(goodsSkuInfo.getStockId()));
        goodsSku.setCardLibraryId(this.parseString2Long(goodsSkuInfo.getCardLibraryId()));
        return goodsSku;
    }

    @Override
    protected String getAttributeJson(DuibaLiveSupplierGoodsSkuDto sku) {
        return sku.getAttributeJson();
    }

    @Override
    protected GoodsSkuInfo toVo(DuibaLiveSupplierGoodsSkuDto sku) {
        GoodsSkuInfo goodsSkuInfo = new GoodsSkuInfo();
        goodsSkuInfo.setId(this.parseLong2String(sku.getId()));
        goodsSkuInfo.setFacePrice(UnitUtils.transformFen2Yuan(sku.getFacePrice()));
        goodsSkuInfo.setSalePrice(UnitUtils.transformFen2Yuan(sku.getSalePrice()));
        goodsSkuInfo.setCostPrice(UnitUtils.transformFen2Yuan(sku.getCostPrice()));
        goodsSkuInfo.setPopShowPrice(UnitUtils.transformFen2Yuan(sku.getPopShowPrice()));
        goodsSkuInfo.setSuggestMarketPrice(UnitUtils.transformFen2Yuan(sku.getSuggestMarketPrice()));
        goodsSkuInfo.setMerchantCoding(sku.getMerchantCoding());
        goodsSkuInfo.setImgUrl(sku.getImgUrl());
        goodsSkuInfo.setRemaining(sku.getRemaining());
        goodsSkuInfo.setPreRemaining(sku.getRemaining());
        goodsSkuInfo.setTotalStock(sku.getTotalStock());
        goodsSkuInfo.setStockId(this.parseLong2String(sku.getStockId()));
        goodsSkuInfo.setCardLibraryId(this.parseLong2String(sku.getCardLibraryId()));
        return goodsSkuInfo;
    }

    @Override
    protected GoodsSkuInfo getSkuInfo(SkuAttributeNode<GoodsSkuInfo> node) {
        GoodsSkuInfo goodsSkuInfo = super.getSkuInfo(node);
        goodsSkuInfo.setImgUrl(node.getImgUrl());
        return goodsSkuInfo;
    }

    @Override
    protected void postNode(SkuAttributeNode<GoodsSkuInfo> headNode, SkuAttributeNode<GoodsSkuInfo> node) {
        if (node.getSkuInfo() != null) {
            if (headNode.getImgUrl() == null) {
                headNode.setImgUrl(node.getSkuInfo().getImgUrl());
            }
            node.getSkuInfo().setImgUrl(null);
        }
    }
}

