package cn.com.duiba.kjy.api.api.dto.wxmessage.customer;

import cn.com.duiba.kjy.api.api.dto.wxmessage.BaseMessageDto;
import lombok.Data;
import org.hibernate.validator.constraints.NotBlank;

/**
 * Created by dugq on 2020-02-06.
 * 音乐消息体
 */
@Data
public class CustomerMusicDto extends BaseMessageDto {
    private static final long serialVersionUID = 8909350057291596210L;
    /**
     * 标题
     */
    @NotBlank(message = "music消息标题不能为空")
    private String title;
    /**
     * 描述
     */
    @NotBlank(message = "music消息描述不能为空")
    private String desc;
    /**
     * 第三方音频文件地址 三选一
     */
    private String thirdPartUrl;
    /**
     * 第三方高清音频文件 三选一
     */
    private String hqThirdPartUrl;
    /**
     * 存在微信方文件的媒体ID
     */
    private String mediaId;
}
