package cn.com.duiba.kjy.api.api.dto.wechat;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 存储微信授权方的access_token和refresh_token
 * @Author xujing
 * @Date 2021/1/25 7:46 下午
 */
@Data
public class WxAuthorizerAccessTokenDto implements Serializable {

    private static final long serialVersionUID = -7060358139652681934L;
    /**
     * 主键
     */
    private Long id;

    /**
     * 微信公众号appid
     */
    private String appId;

    /**
     * 授权方令牌
     */
    private String authorizerAccessToken;

    /**
     * 截止时间
     */
    private Long expiresIn;

    /**
     * 接口调用凭据刷新令牌
     */
    private String authorizerRefreshToken;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}