package cn.com.duiba.kjy.api.api.dto.wechat.coupon;

import cn.com.duiba.kjy.api.api.enums.DelEnum;
import cn.com.duiba.kjy.api.api.enums.wechat.coupon.CouponStockStatusEnum;
import cn.com.duiba.kjy.api.api.enums.wechat.coupon.CouponStockTypeEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 微信支付优惠券批次表
 * @Author xujing
 * @Date 2021/7/28 11:38 上午
 */
@Data
public class WxPayCouponStockDto implements Serializable {

    private static final long serialVersionUID = 8772355454243809720L;
    /**
     * 主键
     */
    private Long id;

    /**
     * 微信侧批次id
     */
    private String wxStockId;

    /**
     * 批次名称
     */
    private String stockName;

    /**
     * 批次备注
     */
    private String stockContent;

    /**
     * @see CouponStockTypeEnum
     * 批次类型:NORMAL：固定面额满减券批次
     */
    private String stockType;

    /**
     * 商户创建批次凭据号 ,（格式：商户id+日期+流水号）
     */
    private String outRequestNo;

    /**
     * 发放数量
     */
    private Integer maxCoupons;

    /**
     * 单个用户可领取的个数
     */
    private Integer maxCouponsRerUser;

    /**
     * 优惠券面额 单位分
     */
    private Integer couponAmount;

    /**
     * 优惠券使用门槛,若指定可核销商品编码，门槛则为可核销商品部分的消费金额，而不是订单的消费金额,单位分
     */
    private Integer transactionMinimum;

    /**
     * 生效时间
     */
    private Date availableBeginTime;

    /**
     * 失效时间
     */
    private Date availableEndTime;

    /**
     * 指定银行卡支付
     */
    private String limitPay;

    /**
     * 指定商品id可使用,id数组，Json格式
     */
    private String availableItems;

    /**
     * @see CouponStockStatusEnum
     * 批次状态 0未启用 1启用 2禁用
     */
    private Integer stockStatus;

    /**
     * 优惠券创建时间
     */
    private Date createTime;

    /**
     * 优惠券启用时间
     */
    private Date startTime;

    /**
     * 优惠券暂停时间
     */
    private Date pauseTime;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * @see DelEnum
     * 默认0 未删除 1已删除
     */
    private Integer isDel;
}