package cn.com.duiba.kjy.api.api.enums;


import cn.com.duiba.live.tool.exception.ErrorCode;

/**
 * Created by dugq on 2019-02-21.
 */
public enum LiveWechatErrorCode implements ErrorCode {
    //通用
    DATE_ERROR("990001","数据错误"),
    GET_LOCK_FAIL("990002", "获取分布式锁失败"),
    SYSTEM("999999", "系统错误"),

    //01 微信统一接口
    WECHAT_OA_TOKEN_ERROR("010001", "token错误"),
    NOT_SUPPORT_MESSAGE("010002", "不支持的消息"),

    //02 微信消息推送
    PARAM_ERROR("020001", "参数错误"),
    FUNCTION_DOWN("020002", "功能已下线"),

    // 03 微信接口定制api
    HANDLER_NOT_FUND("030001", "未找到定制接口处理类"),
    ;

    private String shortCode;
    private String desc;

    LiveWechatErrorCode(String shortCode, String desc) {
        this.shortCode = shortCode;
        this.desc = desc;
    }

    public String getCode() {
        return getHost()+ getShortCode();
    }

    public String getHost() {
        return "04";//NOSONAR
    }

    public String getShortCode() {
        return shortCode;
    }

    public String getDesc() {
        return desc;
    }
}
