package cn.com.duiba.kjy.api.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;

/**
 * 小程序码业务类型枚举
 *
 * @author xuzhigang
 * @date 2020/9/22 12:28 下午
 **/
@Getter
@AllArgsConstructor
public enum MpQrcodeBizTypeEnum {
    LIVE_VISITOR_SHARE(1, "pages/index/index", "kjy/live/mpQrCode", "直播访客分享"),
    ;
    /**
     * 业务类型
     */
    private Integer type;

    /**
     * 小程序码跳转页
     */
    private String page;

    /**
     * 小程序码上传至oss地址前缀
     */
    private String ossPrefix;

    /**
     * 描述
     */
    private String desc;

    public static MpQrcodeBizTypeEnum getEnumByType(Integer type) {
        return Arrays.stream(values()).filter(mpQrcodeBizTypeEnum -> Objects.equals(type, mpQrcodeBizTypeEnum.getType()))
                .findFirst()
                .orElse(null);
    }
}
