package cn.com.duiba.kjy.api.api.enums.wechat;

import com.google.common.collect.Collections2;

import java.util.Arrays;
import java.util.Collection;

/**
 * Created by sunyan on 2018/1/30.
 */
public enum WeappAuditEventEnum {
    SUCCESS("weapp_audit_success", 0, "审核通过"),
    FAIL("weapp_audit_fail", 1, "审核失败");

    private String key;

    private int value;

    private String desc;

    public static WeappAuditEventEnum getByKey(String key) {
        Collection<WeappAuditEventEnum> result = Collections2.filter(Arrays.asList(values()), (gs) -> {
            return gs.getKey().equals(key);
        });
        return result.isEmpty() ? null : result.iterator().next();
    }

    WeappAuditEventEnum(String key, int value, String desc) {
        this.key = key;
        this.value = value;
        this.desc = desc;
    }

    public String getKey() {
        return key;
    }

    public int getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }
}
