package cn.com.duiba.kjy.api.api.remoteservice.wechat;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.api.dto.wechat.AuthorizerCodeDto;
import cn.com.duiba.kjy.api.api.dto.wechat.CodeManageDto;
import cn.com.duiba.kjy.api.api.dto.wechat.WxMpXmlMessageDto;

import java.util.List;

/**
 * 微信小程序代码管理api
 *
 * @Author xujing
 * @Date 2021/1/26 11:29 上午
 */
@AdvancedFeignClient
public interface RemoteWechatMiniCodeManageService {

    /**
     * 为授权的小程序帐号上传小程序代码
     *
     * @param templateId
     * @param appId
     * @return
     */
    boolean commit(Long templateId, String appId) throws BizException;

    /**
     * 提交审核
     *
     * @param appId
     * @return
     */
    boolean submitAudit(String appId) throws BizException;

    /**
     * 手动刷新审核状态
     *
     * @param appId
     */
    void updateAuditstatus(String appId) throws BizException;

    /**
     * 发布审核通过的版本
     *
     * @param appId
     */
    void release(String appId) throws BizException;

    /**
     * 撤回审核
     *
     * @param appId
     */
    void undocodeaudit(String appId) throws BizException;

    /**
     * 获取体验版二维码
     *
     * @param appId
     * @return
     */
    String getQrCode(String appId, String path) throws BizException;


    /**
     * 加急审核
     *
     * @param appId
     * @return
     */
    Boolean speedAudit(String appId, Integer auditid) throws BizException;

    /**
     * 更新审核状态
     *
     * @return
     */
    Boolean updateAuditstatusByCallBack(WxMpXmlMessageDto wxMpXmlMessageDto);

    /**
     * 查询小程序各版本号
     */
    List<CodeManageDto> listAppVersion(String appId);

    /**
     * 根据appId 查出当前app的审核版本 线上版本 体验版本
     */
    AuthorizerCodeDto findAuthorizerCodeDtoByAppId(String appId);

    /**
     * 版本回退
     */
    Boolean revertCodeRelease(String authorizerAppid) throws BizException ;
}
