package cn.com.duiba.kjy.api.api.remoteservice.wechat;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.api.dto.wechat.SessionDto;
import cn.com.duiba.kjy.api.api.dto.wechat.WxAuthorizerDto;
import cn.com.duiba.kjy.api.api.dto.wechat.WxMpXmlMessageDto;
import cn.com.duiba.kjy.api.api.enums.wechat.AppTypeEnum;

/**
 * wx第三方平台接口调用
 *
 * @Author xujing
 * @Date 2021/1/25 6:32 下午
 */
@AdvancedFeignClient
public interface RemoteWechatThirdPartyService {
    /**
     * 授权回调
     *
     * @param authCode
     * @param appType 0用户端 1管理端
     * @throws BizException
     */
    WxAuthorizerDto authorize(String authCode, AppTypeEnum appType) throws BizException;

    /**
     * 获得授权url
     * 0用户端 1管理端
     * @return
     */
    String getAuthorization(AppTypeEnum appType) throws BizException;

    /**
     * 接收微信推送 ticket
     *
     * @param xmlStr
     * @param msgSingnatrue
     * @param timestamp
     * @param nonce
     */
    void receiveTicket(String xmlStr, String msgSingnatrue, String timestamp, String nonce) throws BizException;


    /**
     * 小程序登陆code换sessionkey
     * @param saasModel 是否saas模式
     * @param appId 小程序appid
     * @param code  登录时获取的 code
     * @param appSecret 非saas模式需要提供密钥
     * @return
     */
    SessionDto jscode2session(Integer saasModel, String appId, String code, String appSecret) throws BizException;


    /**
     * 解密微信推送消息
     *
     * @param xml
     * @param msgSingnatrue
     * @param timestamp
     * @param nonce
     * @param appid
     */
    WxMpXmlMessageDto decryptionMsg(String xml, String msgSingnatrue, String timestamp, String nonce, String appid);


    /**
     * 全网发布测试
     * @param code
     * @param openId
     * @throws BizException
     */
    void test(String code,String openId) throws BizException;

}
