package cn.com.duiba.kjy.api.api.bean.wxpay.request;

import cn.com.duiba.kjy.api.api.annotation.FieldMapKey;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

/**
 * 微信企业付款到零钱
 * @author lizhi
 * @date 2020/4/1 3:40 PM
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class WxPayCompanyRequest extends BaseWxRequest {

    private static final long serialVersionUID = 4348146237344197479L;

    /**
     * 商户账号appid
     * String(128)
     */
    @FieldMapKey("mch_appid")
    @NotNull(message = "mchAppId must not be null")
    @Size(max = 128, message = "appId过长")
    private String mchAppId;

    /**
     * 微信支付分配的商户号
     * String(32)
     */
    @FieldMapKey("mchid")
    @NotNull(message = "mchId must not be null")
    @Size(max = 32, message = "商户id过长")
    private String mchId;

    /**
     * 商户订单号，需保持唯一性
     * String(32)
     */
    @FieldMapKey("partner_trade_no")
    @NotNull(message = "partnerTradeNo must not be null")
    @Size(max = 32, message = "partnerTradeNo过长")
    private String partnerTradeNo;

    /**
     * 商户appid下，某用户的openid
     * String(64)
     */
    @FieldMapKey("openid")
    @NotNull(message = "openId must not be null")
    @Size(max = 64, message = "openId过长")
    private String openId;

    /**
     * 校验用户姓名选项
     * String(16)
     *
     * NO_CHECK：不校验真实姓名
     * FORCE_CHECK：强校验真实姓名
     */
    @FieldMapKey("check_name")
    @NotNull(message = "checkName must not be null")
    @Size(max = 16, message = "checkName过长")
    private String checkName;

    /**
     * 企业付款金额，单位为分
     */
    @FieldMapKey("amount")
    @NotNull(message = "amount must not be null")
    private Integer amount;

    /**
     * 企业付款备注
     * String(100)
     */
    @FieldMapKey("desc")
    private String desc;

    /**
     * Ip地址
     * String(32)
     * 非必填
     * 该IP同在商户平台设置的IP白名单中的IP没有关联，该IP可传用户端或者服务端的IP。
     */
    @FieldMapKey("spbill_create_ip")
    private String spbillCreateIp;
}
