package cn.com.duiba.kjy.api.api.remoteservice.wechat.customapi;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.api.bean.WechatServiceException;
import cn.com.duiba.kjy.api.api.dto.wechat.SessionDto;
import cn.com.duiba.kjy.api.api.param.wechat.LiveMpAuthPhoneParam;

import java.awt.image.BufferedImage;

/**
 * @author chengsiyi
 * @date 2021/8/24 14:59
 */
@AdvancedFeignClient
public interface RemoteCustomWechatApiService {

    /**
     * 判断小程序是否由第三方代理
     * @param appId 微信appId
     * @return 结果
     */
    boolean thirdProxy(String appId);

    /**
     * 获取用户信息
     *
     * @param appId 微信appId
     * @param code 临时登录凭证
     * @return 用户信息
     */
    SessionDto getUserInfo(String appId, String code) throws WechatServiceException;

    /**
     * 手机号授权
     * @param param 参数
     */
    boolean mpAuthPhone(LiveMpAuthPhoneParam param) throws WechatServiceException;

    /**
     * 获取小程序二维码流
     *
     * @param scene 场景值
     * @param page  页面
     * @return base64图片
     */
    String getWxCodeUnLimitBase64(String appId, String scene, String page) throws WechatServiceException;
}
