package cn.com.duiba.kjy.api.api.bean.wxpay.result;

import cn.com.duiba.kjy.api.api.annotation.FieldMapKey;
import cn.com.duiba.kjy.api.api.bean.base.BaseResponseResult;
import cn.com.duiba.kjy.api.api.enums.ResponseCodeEnum;
import lombok.Data;

/**
 * 微信公共返回结果
 * @author lizhi
 * @date 2020/4/1 3:22 PM
 */
@Data
public class BaseWxResult extends BaseResponseResult {

    private static final long serialVersionUID = -8538332490331990780L;

    /**
     * 返回状态码.
     * 表示通信是否成功
     */
    @FieldMapKey("return_code")
    private String returnCode;

    /**
     * 返回信息.
     */
    @FieldMapKey("return_msg")
    private String returnMsg;

    //当return_code为SUCCESS的时候，还会包括以下字段：
    /**
     * 业务结果.
     */
    @FieldMapKey("result_code")
    private String resultCode;

    /**
     * 错误代码.
     */
    @FieldMapKey("err_code")
    private String errCode;

    /**
     * 错误代码描述.
     */
    @FieldMapKey("err_code_des")
    private String errCodeDes;


    /**
     * 判断结果是否成功
     * @return 是否成功，true-成功，false-失败
     */
    public boolean isSuccessResult() {
        if (!ResponseCodeEnum.SUCCESS.getCode().equals(this.getReturnCode())) {
            return false;
        }
        return ResponseCodeEnum.SUCCESS.getCode().equals(this.getResultCode());
    }
}