package cn.com.duiba.kjy.api.api.enums;

import java.util.Objects;

/**
 * Created by dugq on 2019-06-01.
 */
public enum OATypeEnum {
    CONTENT_MAIN_OA(1,OaTargetEnum.OA.getCode(),"内容主体公众号"),
    VIP_OA(2,OaTargetEnum.OA.getCode(),"付费用户的VIP专属公众号"),
    MP(3,2,"客集集主体小程序"),
    CLIENT_PUSH_MP(4,OaTargetEnum.MP.getCode(),"客户接收私信消息的小程序"),

    FISSION_MP(5,OaTargetEnum.MP.getCode(),"微信裂变小程序"),

    GAME_MP(6,OaTargetEnum.MP.getCode(),"抽奖模板小程序"),

    GREETING_MP(7,OaTargetEnum.MP.getCode(),"节日贺卡小程序"),

    INNER_SALE(8,OaTargetEnum.WEB.getCode(),"内部销售web应用"),

    LIVE_USER_MP(9, OaTargetEnum.MP.getCode(), "直播用户端"),


    ;
    private Integer type;
    //1:公众号 2：小程序 3:web应用
    private Integer target;
    private String desc;

    OATypeEnum(Integer type,Integer target, String desc) {
        this.type = type;
        this.target = target;
        this.desc = desc;
    }

    public Integer getTarget() {
        return target;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static OATypeEnum typeOf(Integer type) {
        for (OATypeEnum e :values())
            if (Objects.equals(type, e.getType())) {
                return e;
            }
        throw new UnsupportedOperationException("不支持的oa类型");
    }

}
