package cn.com.duiba.kjy.api.api.bean.wxpay.request;

import cn.com.duiba.kjy.api.api.annotation.FieldMapKey;
import cn.com.duiba.kjy.api.api.bean.base.BaseRequestResult;
import lombok.Data;

import javax.validation.constraints.Size;

/**
 * 微信公共请求参数
 * @author lizhi
 * @date 2020/4/1 4:09 PM
 */
@Data
public class BaseWxRequest extends BaseRequestResult {

    private static final long serialVersionUID = -5331363233089383340L;

    /**
     * 随机字符串
     * String(32)
     */
    @FieldMapKey("nonce_str")
    @Size(max = 32, message = "随机字符串过长")
    private String nonceStr;

    /**
     * 签名
     * String(32)
     */
    @FieldMapKey("sign")
    @Size(max = 32, message = "签名过长")
    private String sign;
}
