package cn.com.duiba.kjy.api.api.dto.payment.request.wxpay;

import cn.com.duiba.kjy.api.api.annotation.BizTypeEnumCheck;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;

/**
 * 企业付款到零钱，查询参数
 * @author lizhi
 * @date 2020/4/1 5:00 PM
 */
@Data
public class WxPayCompanyQueryRequest implements Serializable {

    private static final long serialVersionUID = 7126662147234732081L;

    /**
     * 上游调用方的订单号
     */
    @NotBlank(message = "业务方订单号不能为空")
    @Size(max = 25, message = "业务方订单号不能超过25位")
    private String bizTradeNo;

    /**
     * 分配给业务方的类型和bizTradeNo配合使用
     * bizType + bizTradeNo 保证唯一
     * @see cn.com.duiba.kjy.api.api.enums.BizTypeEnum
     */
    @NotNull(message = "bizType不能为空")
    @BizTypeEnumCheck
    private Integer bizType;
}
