package cn.com.duiba.kjy.api.api.dto.wechat;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 用户代码审核记录
 * @Author xujing
 * @Date 2021/1/27 11:37 上午
 */
@Data
public class WxAuthorizerTemplateDto implements Serializable {

    private static final long serialVersionUID = 4237428251086778533L;
    /**
    * 主键
    */
    private Long id;

    /**
    * appId
    */
    private String appId;

    /**
    * 模板id
    */
    private Long templateId;

    /**
    * 审核id
    */
    private Long auditId;

    /**
    * 版本
    */
    private String userVersion;

    /**
    * 描述
    */
    private String userDesc;

    /**
    * 类型
     * @see cn.com.duiba.kjy.api.api.enums.wechat.TemplateTypeEnum
    */
    private Integer templateType;

    /**
    * 状态
     * @see cn.com.duiba.kjy.api.api.enums.wechat.TemplateStatusEnum
    */
    private Integer templateStatus;

    /**
    * 失败原因
    */
    private String failReason;

    /**
    * gmtCreate
    */
    private Date gmtCreate;

    /**
    * gmtModified
    */
    private Date gmtModified;
}