package cn.com.duiba.kjy.api.api.remoteservice.wechat;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.api.param.wechat.ModifyDomainParam;
import cn.com.duiba.kjy.api.api.param.wechat.WebviewDomainParam;
import me.chanjar.weixin.common.exception.WxErrorException;

/**
 * 微信小程序基础信息设置api
 * @Author xujing
 * @Date 2021/1/26 11:29 上午
 */
@AdvancedFeignClient
public interface RemoteWechatMiniBaseInfoService {

    /**
     * 设置服务器域名
     */
    void modifyDomain(ModifyDomainParam modifyDomainParam) throws BizException;

    /**
     * 设置业务域名
     */
    void setWebviewDomain(WebviewDomainParam webviewDomain) throws BizException;


    /**
     * 获取服务器域名
     */
    ModifyDomainParam getDomain(String appId) throws BizException;

    /**
     * 获取业务域名
     */
    WebviewDomainParam getWebviewDomain(String appId) throws BizException;

}
