package cn.com.duiba.kjy.api.api.param.wechat;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.io.Serializable;

/**
 * @Author xujing
 * @Date 2021/1/26 2:59 下午
 */
@Data
public class SendSubscribeMessageRequestParam implements Serializable {


    private static final long serialVersionUID = -2960835313979391020L;
    private String appId;

    /**
     * 接收者（用户）的 openid 必填
     */
    private String touser;
    /**
     * 所需下发的订阅模板id 必填
     */
    @JSONField(name = "template_id")
    private String templateId;

    /**
     * 点击模板卡片后的跳转页面，仅限本小程序内的页面。支持带参数,（示例index?foo=bar）。该字段不填则模板无跳转。非必填
     */
    private String page;

    /**
     * 跳转小程序类型：developer为开发版；trial为体验版；formal为正式版；默认为正式版 非必填
     */
    @JSONField(name = "miniprogram_state")
    private String miniprogramState;

    /**
     * 进入小程序查看”的语言类型，支持zh_CN(简体中文)、en_US(英文)、zh_HK(繁体中文)、zh_TW(繁体中文)，默认为zh_CN 非必填
     */
    private String lang;

    /**
     * 模板内容，格式形如 { "key1": { "value": any }, "key2": { "value": any } } 必填
     */
    private Object data;

}
