/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.api.api.enums;

import java.util.Objects;

public enum MessageTypeEnum {
    CUSTOMER_TEXT(1, "text", "\u5ba2\u670d\u6587\u5b57\u6d88\u606f"),
    CUSTOMER_PIC(2, "image", "\u5ba2\u670d\u56fe\u7247\u6d88\u606f"),
    CUSTOMER_VOICE(3, "voice", "\u5ba2\u670d\u97f3\u9891\u6d88\u606f"),
    CUSTOMER_MUSIC(4, "music", "\u5ba2\u670d\u97f3\u4e50\u6d88\u606f"),
    CUSTOMER_VIDEO(5, "video", "\u5ba2\u670d\u89c6\u9891\u6d88\u606f"),
    CUSTOMER_CARD(6, "news", "\u5ba2\u670d\u5361\u7247\u6d88\u606f"),
    CUSTOMER_MENU(7, "msgmenu", "\u5ba2\u670d\u83dc\u5355\u6d88\u606f"),
    CUSTOMER_MP_CARD(8, "miniprogrampage", "\u5ba2\u670d\u5c0f\u7a0b\u5e8f\u6d88\u606f"),
    CUSTOMER_COUPON(9, "wxcard", "\u5ba2\u670d\u5361\u5238\u6d88\u606f"),
    TEMPLATE(10, "template", "\u6a21\u7248\u6d88\u606f"),
    SUBSCRIBE(11, "subscribe", "\u8ba2\u9605\u6d88\u606f");

    private final Integer code;
    private String wxType;
    private String desc;

    private MessageTypeEnum(Integer code, String wxType, String desc) {
        this.code = code;
        this.wxType = wxType;
        this.desc = desc;
    }

    public Boolean isCustomerMessage() {
        return this.code < TEMPLATE.getCode();
    }

    public Boolean isTemplateMessage() {
        return this.code.equals(TEMPLATE.getCode());
    }

    public Boolean isSubscribeMessage() {
        return this.code.equals(SUBSCRIBE.getCode());
    }

    public String getWxType() {
        return this.wxType;
    }

    public final Integer getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    public static MessageTypeEnum getByCode(Integer code) {
        for (MessageTypeEnum e : MessageTypeEnum.values()) {
            if (!Objects.equals(code, e.getCode())) continue;
            return e;
        }
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u6d88\u606f\u7c7b\u578b");
    }
}

