package cn.com.duiba.log.api.aop;

import cn.com.duiba.log.api.annotation.LoggerMethod;
import cn.com.duiba.log.api.context.LoggerThreadContext;
import cn.com.duiba.log.api.exception.LogRunTimeException;
import cn.com.duiba.log.api.service.MyLogger;
import cn.com.duiba.log.api.util.BraveTraceUtil;
import com.alibaba.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;

import java.lang.reflect.Method;
import java.util.Objects;

/**
 * @Description 日志切面
 * 封装
 * @Author dangcang
 * @Date 2021/11/3 11:02 上午
 **/
@Slf4j
@Component
@Aspect
public class LoggerInterceptor {


    @Around("@annotation(cn.com.duiba.log.api.annotation.LoggerMethod)")
    public Object logger(ProceedingJoinPoint point) throws Throwable {

        Object result = null;
        try {
            MethodSignature methodSignature = (MethodSignature) point.getSignature();
            Method method = methodSignature.getMethod();
            LoggerMethod loggerMethod = AnnotationUtils.findAnnotation(method, LoggerMethod.class);
            String template = Objects.requireNonNull(loggerMethod).value();
            String group = loggerMethod.group();
            String request = JSON.toJSONString(point.getArgs());
            if (StringUtils.isBlank(template)) {
                throw new LogRunTimeException("操作日志: " + group + ", template不能为空");
            }
            LoggerThreadContext context = new LoggerThreadContext();
            context.setTemplate(template);
            context.setGroup(group);
            context.setRequest(request);
            context.setTraceId(BraveTraceUtil.getTracerId());
            MyLogger.setLoggerThreadContext(context);
            result = point.proceed();
            MyLogger.setResponse(JSON.toJSONString(result));
        } catch (LogRunTimeException e) {
            throw new LogRunTimeException(e.getMessage());
        } catch (Exception e) {
            log.error("Aspect Exception methodName:{} params:{}", point.getSignature().getName(),
                    JSON.toJSONString(point.getArgs()), e);
        } finally {
            MyLogger.flush();
        }
        return result;
    }

}