package cn.com.duiba.log.api.appender;

import cn.com.duiba.application.boot.api.component.environment.Environment;
import cn.com.duiba.application.boot.api.component.environment.RequestEnvironmentDecisionMaker;
import cn.com.duiba.log.api.config.LogRecordSourceConfig;
import cn.com.duiba.log.api.model.param.LogParam;
import cn.com.duiba.log.api.mq.producer.MqLogMessageProducer;
import cn.com.duiba.log.api.remoteservice.RemoteLogService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * @Description 操作日志接收器实现类
 * @Author dangcang
 * @Date 2021/11/3 1:47 下午
 **/
@Slf4j
@Component
public class LogAppenderServiceImpl implements LogAppenderService {

    @Resource
    private RequestEnvironmentDecisionMaker requestEnvironmentDecisionMaker;

    @Resource
    private LogRecordSourceConfig logRecordSourceConfig;

    @Resource
    private RemoteLogService remoteLogService;

    @Resource
    private MqLogMessageProducer mqLogMessageProducer;


    @Override
    public void acceptLog(LogParam param) {

        Environment environment = requestEnvironmentDecisionMaker.getRequestEnvironment();

        param.setEnvironment(environment.getEnvId());

        try {

            //根据配置决定发消息还是直接走api

            if (logRecordSourceConfig.mq()) {

                //这里我应该要发消息出去了
                mqLogMessageProducer.send(param);

                return;
            }

            remoteLogService.log(param);

        } catch (Exception e) {
            log.error("系统日志记录操作失败，cause:", e);
        }
    }
}