package cn.com.duiba.log.api.config;

import cn.com.duiba.log.api.service.LogApplicationService;
import cn.com.duiba.log.api.util.SystemInfoUtil;
import cn.com.duiba.wolf.threadpool.NamedThreadFactory;
import cn.com.duibaboot.ext.autoconfigure.threadpool.policy.AbortPolicyWithReport;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/**
 * @author xiaotian
 */
@EnableScheduling
@Configuration
public class BasicConfiguration {

    @Bean
    public SystemInfoUtil initSysytem() {
        return new SystemInfoUtil();
    }

    @Bean
    public LogApplicationService ssoSystemService() {
        return new LogApplicationService();
    }


    @Bean(name = "logExecutorService")
    public ExecutorService logExecutorService() {
        BlockingQueue<Runnable> queue = new ArrayBlockingQueue<>(500);
        return new ThreadPoolExecutor(10, 40,
                60L, TimeUnit.SECONDS,
                queue,
                new NamedThreadFactory("log"),
                new AbortPolicyWithReport());
    }

}
