package cn.com.duiba.log.api.config;

import brave.Tracer;
import cn.com.duiba.log.api.util.BraveTraceUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * 功能描述：在客户端引入brave的情况下才获取traceId
 *
 * @Auther: xiaotian
 * @Date: 2021/11/9 14:00
 * @Description:
 */
@Configuration
@ConditionalOnClass({Tracer.class})
public class BraveTraceConfigurator {

    @Autowired
    private Tracer tracer;


    @Bean(name = "braveTraceUtil")
    @ConditionalOnMissingBean
    public BraveTraceUtil tracer() {
        BraveTraceUtil.setTracer(tracer);
        return new BraveTraceUtil();
    }

}
