package cn.com.duiba.log.api.context;

import cn.com.duiba.log.api.constant.Constant;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;

import java.util.Stack;

/**
 * @Description 日志暂存区
 * @Author dangcang
 * @Date 2021/11/3 2:21 下午
 **/
@Slf4j
public class LoggerStackContext {

    private final Stack<LoggerThreadContext> loggerStack = new Stack<>();

    public void addContext(LoggerThreadContext context) {
        if (loggerStack.size() > Constant.MAX_STACK_NUM) {
            log.warn("操作日志提交线程超过上限:" + Constant.MAX_STACK_NUM);
            return;
        }
        loggerStack.push(context);
    }

    public void addLogParam(JSONObject param) {
        if (loggerStack.isEmpty()) {
            return;
        }
        LoggerThreadContext context = loggerStack.peek();
        context.addParam(param);
    }

    public void addResponse(String response) {
        if (loggerStack.isEmpty()) {
            return;
        }
        LoggerThreadContext context = loggerStack.peek();
        context.setResponse(response);
    }

    public void addOperator(String operator) {
        if (loggerStack.isEmpty()) {
            return;
        }
        LoggerThreadContext context = loggerStack.peek();
        context.setOperatorId(operator);
    }

    public LoggerThreadContext popContext() {
        if (loggerStack.isEmpty()) {
            return null;
        }
        return loggerStack.pop();
    }

    public Boolean isEmpty() {
        return loggerStack.isEmpty();
    }

}