package cn.com.duiba.log.api.context;

import cn.com.duiba.log.api.exception.LogRunTimeException;
import cn.com.duiba.log.api.model.param.RequestParam;
import cn.com.duiba.wolf.perf.timeprofile.RequestTool;
import lombok.extern.slf4j.Slf4j;

import javax.servlet.http.HttpServletRequest;
import java.util.Objects;

/**
 * @Description 请求头的一些参数获取
 * @Author dangcang
 * @Date 2021/11/5 10:13 上午
 **/
@Slf4j
public class RequestContext {

    private static final ThreadLocal<RequestParam> threadRequestParam = new ThreadLocal<>();

    public static void setRequestInThreadLocal(HttpServletRequest request) {
        if (Objects.isNull(request)) {
            throw new LogRunTimeException("解析request为空");
        }
        RequestParam requestParam = new RequestParam();
        requestParam.setIp(RequestTool.getIpAddr(request));
        requestParam.setUrl(RequestTool.getRequestUrl(request));
        requestParam.setUri(request.getRequestURI());
        threadRequestParam.set(requestParam);
    }

    public static void removeRequestInThreadLocal() {
        threadRequestParam.remove();
    }

    public static RequestParam getRequestParam() {
        RequestParam requestParam = threadRequestParam.get();
        if (Objects.isNull(requestParam)) {
            throw new LogRunTimeException("获取源数据失败");
        }
        return requestParam;
    }
}