package cn.com.duiba.log.api.model.param;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

/**
 * @Description 日志参数
 * todo 日志参数根据ES需要增加字段
 * @Author dangcang
 * @Date 2021/11/3 11:25 上午
 **/
@Data
public class LogParam implements Serializable {

    private static final long serialVersionUID = -4850897678376011248L;

    /**
     * 应用id
     */
    @NotNull
    private Long appId;

    /**
     * 系统名称
     */
    @NotBlank
    private String serverName;

    /**
     * 模块名称
     */
    @NotBlank
    private String group;

    /**
     * 请求的url
     */
    private String url;

    /**
     * 请求的uri
     */
    private String uri;

    /**
     * 提交日志的ip
     */
    @NotBlank
    private String ip;

    /**
     * 提交日志的链路id
     */
    private String traceId;

    /**
     * 操作人id
     */
    private String operatorId;

    /**
     * 请求参数
     */
    private String request;

    /**
     * 返回参数
     */
    private String response;

    /**
     * 渲染后的日志正文
     */
    private String logContent;

    /**
     * 日志参数
     */
    private String params;

    /**
     * 当前环境
     */
    @NotBlank
    private String environment;

    /**
     * 日志发生时间
     */
    private Date actionTime;

}