package cn.com.duiba.log.api.mq.config;

import cn.com.duiba.application.boot.api.ApplicationProperties;
import cn.com.duiba.application.boot.api.component.environment.RequestEnvironmentDecisionMaker;
import cn.com.duiba.log.api.mq.producer.MqLogMessageProducer;
import cn.com.duibaboot.ext.autoconfigure.rocketmq.DefaultMQProducerWrapper;
import org.apache.commons.lang.StringUtils;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import javax.annotation.Resource;

/**
 * 功能描述：日志系统mq producer配置
 *
 * @Auther: xiaotian
 * @Date: 2021/11/9 14:00
 * @Description:
 */
@Configuration
@ConditionalOnClass({DefaultMQProducer.class})
@EnableConfigurationProperties({LogRocketMqProperties.class, ApplicationProperties.class})
@AutoConfigureAfter(value = RequestEnvironmentDecisionMaker.class)
public class LogMqProducerConfigurator implements InitializingBean {

    @Autowired
    protected LogRocketMqProperties logRocketMqProperties;

    @Autowired
    protected ApplicationProperties applicationProperties;

    @Resource
    private RequestEnvironmentDecisionMaker requestEnvironmentDecisionMaker;


    @Override
    public void afterPropertiesSet() throws Exception {
        DefaultMQProducerWrapper p = new DefaultMQProducerWrapper();
        String env = requestEnvironmentDecisionMaker.getRequestEnvironment().getEnvId();
        String appName = applicationProperties.getName();
        if (StringUtils.isBlank(appName) || StringUtils.isBlank(env)) {
            throw new IllegalArgumentException("日志mq生产者创建失败");
        }
        p.setProducerGroup("PID-" + appName + "-" + env);
        String name = logRocketMqProperties.getNameSrvAddr();
        if (StringUtils.isBlank(name)) {
            throw new IllegalArgumentException("日志mq生产者创建失败,nameSrvAddr为空");
        }
        p.setNamesrvAddr(name);
        p.setSendMsgTimeout(logRocketMqProperties.getProducer().getSendMsgTimeoutMillis());
        p.start();
        MqLogMessageProducer.setDefaultMQProducer(p);
    }

}
