package cn.com.duiba.log.api.mq.config;

import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * 功能描述：日志mq生产者配置
 *
 * @Auther: xiaotian
 * @Date: 2021/11/11 13:48
 * @Description:
 */
@ConfigurationProperties(prefix = "duiba.log.rocketmq")
public class LogRocketMqProperties {

        /**
         * Producer属性
         */
        private LogProducerProperties producer = new LogProducerProperties();

        /**
         * RocketMQ nameSrv地址
         */
        private String nameSrvAddr;


        public LogProducerProperties getProducer() {
        return producer;
    }

        public void setProducer(LogProducerProperties producer) {
        this.producer = producer;
    }


        public String getNameSrvAddr() {
            if(nameSrvAddr != null && nameSrvAddr.trim().equals("")){
                return null;
            }
            return nameSrvAddr;
        }

        public void setNameSrvAddr(String nameSrvAddr) {
            this.nameSrvAddr = nameSrvAddr;
        }


        public static class LogProducerProperties{
            /**
             * 是否启用RocketMQ生产者
             */
            private Boolean enable = true;

            /**
             * 发送超时时间，单位：ms，默认：400ms
             */
            private Integer sendMsgTimeoutMillis = 400;

            public Boolean getEnable() {
                return enable;
            }

            public void setEnable(Boolean enable) {
                this.enable = enable;
            }

            public Integer getSendMsgTimeoutMillis() {
                return sendMsgTimeoutMillis;
            }

            public void setSendMsgTimeoutMillis(Integer sendMsgTimeoutMillis) {
                this.sendMsgTimeoutMillis = sendMsgTimeoutMillis;
            }
        }


}
