package cn.com.duiba.log.api.service;

import cn.com.duiba.application.boot.api.domain.dto.ApplicationDto;
import cn.com.duiba.application.boot.api.remoteservice.RemoteApplicationService;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import lombok.extern.slf4j.Slf4j;

import javax.annotation.Resource;
import java.util.concurrent.TimeUnit;

/**
 * @Description 获取当前业务系统的信息
 * @Author dangcang
 * @Date 2021/11/8 11:05 上午
 **/
@Slf4j
public class LogApplicationService {

    @Resource
    private RemoteApplicationService remoteApplicationService;

    private final LoadingCache<String, ApplicationDto> cache = Caffeine.newBuilder()
            .expireAfterWrite(1, TimeUnit.MINUTES)
            .build((systemName) -> {
                ApplicationDto application = remoteApplicationService.getApplicationByAlias(systemName);
                if (application == null) {
                    log.error("systemName:" + systemName + "没有对应的系统配置");
                }
                return application;
            });

    public ApplicationDto getSystemByAlias(String systemAlias) {
        return cache.get(systemAlias);
    }
}