package cn.com.duiba.log.api.service;

import cn.com.duiba.log.api.appender.LogAppenderService;
import cn.com.duiba.log.api.context.LoggerThreadContext;
import cn.com.duiba.log.api.model.dto.LoggerMateInfoDTO;
import cn.com.duiba.log.api.model.param.LogParam;
import cn.com.duiba.log.api.util.SystemInfoUtil;
import cn.com.duiba.log.api.util.TemplateUtil;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.fastjson.JSONObject;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;

import java.util.Date;
import java.util.List;

/**
 * @Description 请描述类的业务用途
 * @Author dangcang
 * @Date 2021/11/5 10:53 上午
 **/
@Slf4j
@Data
public class LoggerRunnable implements Runnable {

    private LoggerThreadContext threadContext;

    private LoggerMateInfoDTO mateInfo;

    private List<LogAppenderService> appenderServiceList;

    /**
     * 异步线程执行消息发送逻辑
     */
    @Override
    public void run() {

        List<JSONObject> paramsList = threadContext.getParams();
        for (JSONObject json : paramsList) {
            try {
                String logContext = TemplateUtil.replaceArgs(threadContext.getTemplate(), json);

                LogParam param = new LogParam();
                param.setActionTime(new Date());
                param.setAppId(SystemInfoUtil.getThisSystemInfo().getId());
                param.setServerName(SystemInfoUtil.getThisSystemInfo().getAppName());
                param.setGroup(threadContext.getGroup());
                param.setTraceId(threadContext.getTraceId());
                param.setOperatorId(threadContext.getOperatorId());
                param.setRequest(threadContext.getRequest());
                param.setResponse(threadContext.getResponse());
                param.setUrl(mateInfo.getUrl());
                param.setUri(mateInfo.getUri());
                param.setIp(mateInfo.getIp());
                param.setParams(json.toJSONString());
                param.setLogContent(logContext);

                for (LogAppenderService appender : appenderServiceList) {
                    try {
                        LogParam clone = new LogParam();
                        BeanUtils.copy(param, clone);
                        appender.acceptLog(clone);
                    } catch (Exception e) {
                        log.error("Class[{}]处理操作日志失败", appender.getClass().getSimpleName(), e);
                    }
                }
            } catch (Exception e) {
                log.error("操作日志发送失败");
            }
        }
    }
}