package cn.com.duiba.log.api.service;

import cn.com.duiba.log.api.context.LoggerThreadContext;
import com.alibaba.fastjson.JSONObject;

import java.util.Objects;

/**
 * @Description 日志发送，转化类
 * @Author dangcang
 * @Date 2021/11/4 10:17 上午
 **/
public class MyLogger {

    private static volatile LoggerService loggerService;

    /**
     * 初始化后注入 loggerService
     *
     * @param loggerService
     */
    public static void setLoggerService(LoggerService loggerService) {
        MyLogger.loggerService = loggerService;
    }

    /**
     * 通过json渲染日志
     *
     * @param json
     */
    public static LoggerService logForJson(JSONObject json) {
        Objects.requireNonNull(json);

        loggerService.log(json);

        return loggerService;
    }

    /**
     * 添加返回参数
     *
     * @param response
     */
    public static LoggerService setResponse(String response) {
        Objects.requireNonNull(response);

        loggerService.addResponse(response);

        return loggerService;
    }

    /**
     * 添加操作人
     *
     * @param operator
     */
    public static LoggerService addOperator(String operator) {
        Objects.requireNonNull(operator);
        loggerService.addOperator(operator);
        return loggerService;
    }


    /**
     * 请求线程前置调用
     *
     * @param context
     */
    public static void setLoggerThreadContext(LoggerThreadContext context) {
        loggerService.setThreadContext(context);
    }

    /**
     * 请求线程后置调用
     */
    public static void flush() {
        loggerService.flushThreadContext();
    }

}