package cn.com.duiba.log.api.util;

import lombok.extern.slf4j.Slf4j;

import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * @Description 自定义通用线程池
 * @Author dangcang
 * @Date 2021/11/4 10:27 上午
 **/
@Slf4j
public class CommonPoolUtil {

    /**
     * 本地线程池
     */
    private static ThreadPoolExecutor localLogThreadPool;

    static {
        //todo 阻塞队列长度及线程数设置
        ThreadFactory logThreadFactory = new MyFactory("log");
        RejectedExecutionHandler handler = new MyIgnorePolicy();
        localLogThreadPool = new ThreadPoolExecutor(5, 20, 60, TimeUnit.SECONDS,
                new LinkedBlockingDeque<>(2000), logThreadFactory, handler);
        //立即启用
        localLogThreadPool.prestartAllCoreThreads();
    }

    private CommonPoolUtil() {
    }

    public static ThreadPoolExecutor getLocalLogThreadPool() {
        return localLogThreadPool;
    }

    public static class MyFactory implements ThreadFactory {

        private final AtomicInteger mThreadNum = new AtomicInteger(1);

        private String threadName;

        public MyFactory() {
        }

        public MyFactory(String threadName) {
            this.threadName = threadName;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, threadName + "-thread-" + mThreadNum.getAndIncrement());
            log.info(t.getName() + " has been created");
            return t;
        }
    }

    public static class MyIgnorePolicy implements RejectedExecutionHandler {

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            doLog(r);
        }

        private void doLog(Runnable r) {
            // 可做日志记录等
            log.error(r.toString() + " rejected");
        }
    }

}