package cn.com.duiba.log.api.util;

import cn.com.duiba.application.boot.api.ApplicationProperties;
import cn.com.duiba.application.boot.api.domain.dto.ApplicationDto;
import cn.com.duiba.log.api.exception.LogRunTimeException;
import cn.com.duiba.log.api.service.LogApplicationService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * @Description 请描述类的业务用途
 * @Author dangcang
 * @Date 2021/11/8 11:09 上午
 **/
@Slf4j
public class SystemInfoUtil {

    private static LogApplicationService systemService;

    private static ApplicationProperties applicationProperties;

    /**
     * 获取本系统的信息
     */
    public static ApplicationDto getThisSystemInfo() {
        ApplicationDto system = systemService.getSystemByAlias(applicationProperties.getApplicationName());
        if (system == null) {
            throw new LogRunTimeException("没有检索到" + applicationProperties.getApplicationName() + "对应的系统配置");
        }
        return system;
    }

    @Autowired
    public void setSsoSystemService(LogApplicationService logApplicationService) {
        SystemInfoUtil.systemService = logApplicationService;
    }

    @Autowired
    public void setApplicationProperties(ApplicationProperties applicationProperties) {
        SystemInfoUtil.applicationProperties = applicationProperties;
    }
}