package cn.com.duiba.log.api.util;

import cn.com.duiba.log.api.exception.LogRunTimeException;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @Description 日志模板参数渲染
 * @Author dangcang
 * @Date 2021/11/5 11:16 上午
 **/
@Slf4j
public class TemplateUtil {

    private static final Pattern PATTERN = Pattern.compile("\\$\\{(.+?)\\}");

    private TemplateUtil() {
    }

    /**
     * 替换模板变量
     */
    public static String replaceArgs(final String template, JSONObject data) {
        // sb用来存储替换过的内容，它会把多次处理过的字符串按源字符串序 存储起来。

        if (Objects.isNull(data)) {
            throw new LogRunTimeException("日志渲染参数为空，模板：" + template);
        }
        if (StringUtils.isBlank(template)) {
            throw new LogRunTimeException("日志渲染模板为空");
        }
        StringBuffer sb = new StringBuffer();
        try {
            Matcher matcher = PATTERN.matcher(template);
            while (matcher.find()) {
                String name = matcher.group(1);
                String value = "";
                if (data.containsKey(name)) {
                    value = data.getString(name);
                    if (Objects.isNull(value)) {
                        throw new LogRunTimeException("日志渲染参数为空，模板：" + template + "异常参数：" + name + "传入参数：" + data.toJSONString());
                    }
                    value = value.replaceAll("\\$", "\\\\\\$");
                }
                matcher.appendReplacement(sb, value);
            }
            matcher.appendTail(sb);
        } catch (Exception e) {
            log.error("渲染失败", e);
        }
        return sb.toString();
    }

}