package cn.com.duiba.cloud.order.center.api.model.dto.order;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @Description 子订单信息
 * @Author dangcang
 * @Date 2021/11/10 4:13 下午
 **/
@Data
public class SubOrderDTO implements Serializable {

    private static final long serialVersionUID = -953811173873911141L;

    /**
     * 订单号
     */
    private String orderCode;

    /**
     * orderSort
     */
    private Integer orderSort;

    /**
     * sku渠道id
     */
    private String skuChannelId;

    /**
     * 商品快照id
     */
    private String snapshotId;

    /**
     * 商品图片
     */
    private String imgSrc;

    /**
     * 商品名称
     */
    private String goodsName;

    /**
     * 备注
     */
    private String remark;

    /**
     * 购买数量
     */
    private Integer saleNumber;

    /**
     * 支付信息
     */
    private List<PaymentDTO> paymentDTOS;

    /**
     * 优惠项信息
     */
    private List<DiscountDTO> discountDTOS;

}