package cn.com.duiba.cloud.order.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.order.center.api.model.dto.order.ConfirmOrderParam;
import cn.com.duiba.cloud.order.center.api.model.dto.order.PayDTO;
import cn.com.duiba.cloud.order.center.api.model.param.order.CancelOrderParam;
import cn.com.duiba.cloud.order.center.api.model.param.order.DeliverGoodsParam;
import cn.com.duiba.cloud.order.center.api.model.param.order.OrderCreateParam;
import cn.com.duiba.cloud.order.center.api.model.param.order.OrderRemarkParam;
import cn.com.duiba.cloud.order.center.api.model.param.order.OrderRemindParam;

/**
 * @Description 订单相关写操作接口
 * @Author dangcang
 * @Date 2021/11/10 1:35 下午
 **/
@AdvancedFeignClient
public interface RemoteOrderWriteService {

    //todo 审批单

    /**
     * 创建订单
     * @param param
     * @return
     * @throws BizException
     */
    PayDTO createOrder(OrderCreateParam param) throws BizException;

    /**
     * 立即支付
     * @param orderId
     * @return
     * @throws BizException
     */
    PayDTO payOrder(Long orderId) throws BizException;

    /**
     * 用户子订单备注
     * @param param
     * @return
     * @throws BizException
     */
    Boolean userOrderRemark(OrderRemarkParam param) throws BizException;

    /**
     * 订单确认
     * @param param
     * @return
     * @throws BizException
     */
    Boolean orderConfirm(ConfirmOrderParam param) throws BizException;

    /**
     * 租户订单备注
     * @param param
     * @return
     * @throws BizException
     */
    Boolean tenantOrderRemark(OrderRemarkParam param) throws BizException;

    /**
     * 取消订单
     * @param param
     * @return
     * @throws BizException
     */
    Boolean cancelOrder(CancelOrderParam param) throws BizException;

    /**
     * 发货接口
     * @param param
     * @return
     * @throws BizException
     */
    Boolean deliveryGoods(DeliverGoodsParam param) throws BizException;

    /**
     * 用户提醒接口
     * @param param
     * @return
     * @throws BizException
     */
    Boolean userOrderRemind(OrderRemindParam param) throws BizException;
}