package cn.com.duiba.cloud.order.center.api.model.param.order;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @Description 创建订单
 * @Author dangcang
 * @Date 2021/11/10 1:57 下午
 **/
@Data
public class OrderCreateParam implements Serializable {

    private static final long serialVersionUID = 1260557828431632752L;
    /**
     * 订单类型
     * @see cn.com.duiba.cloud.order.center.api.enums.OrderTypeEnum
     */
    private Integer orderType;

    /**
     * 地址id
     */
    private Long addressId;

    /**
     * appId
     */
    private Long appId;

    /**
     * 来源 和orderType确定
     */
    private String orderSourceId;

    /**
     * 用户信息相关
     */
    private UserParam userParam;

    /**
     * 商品相关
     */
    private List<GoodsParam> goodsParams;
}