package cn.com.duiba.cloud.order.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.order.center.api.model.dto.order.LogisticsDTO;
import cn.com.duiba.cloud.order.center.api.model.dto.order.OrderDTO;
import cn.com.duiba.cloud.order.center.api.model.dto.order.OrderDetailDTO;
import cn.com.duiba.cloud.order.center.api.model.dto.order.OrderStatusCountDTO;
import cn.com.duiba.cloud.order.center.api.model.dto.order.OrderStatusDTO;
import cn.com.duiba.cloud.order.center.api.model.dto.order.SubOrderGoodsDTO;
import cn.com.duiba.cloud.order.center.api.model.dto.order.UserOrderDetailDTO;
import cn.com.duiba.cloud.order.center.api.model.param.order.OrderQueryParam;
import cn.com.duiba.cloud.order.center.api.model.param.order.OrderStatusCountParam;
import cn.com.duiba.cloud.order.center.api.model.param.order.UserOrderQueryParam;
import cn.com.duiba.cloud.order.center.api.util.UploadResult;
import cn.com.duiba.wolf.entity.PageResponse;

import java.util.List;

/**
 * @Description 订单相关读操作接口
 * @Author dangcang
 * @Date 2021/11/10 1:37 下午
 **/
@AdvancedFeignClient
public interface RemoteOrderReadService {

    /**
     * 分页查询订单接口--后台
     * @param param
     * @return
     * @throws BizException
     */
    PageResponse<OrderDTO> backGroundFind(OrderQueryParam param) throws BizException;

    /**
     * 分页查询订单接口-前台用户
     * @param param
     * @return
     * @throws BizException
     */
    PageResponse<OrderDTO> pageForUser(UserOrderQueryParam param) throws BizException;

    /**
     * 获取订单商品信息、发货信息--后台
     * @param orderCode
     * @return
     * @throws BizException
     */
    LogisticsDTO getLogisticsMsg(String orderCode) throws BizException;

    /**
     * 订单导出
     * @param param
     * @return
     * @throws BizException
     */
    UploadResult exportOrderList(OrderQueryParam param) throws BizException;

    /**
     * 获取订单详情--后台
     * @param orderCode
     * @return
     * @throws BizException
     */
    OrderDetailDTO backgroundGetOrderDetail(String orderCode) throws BizException;

    /**
     * 获取用户订单详情
     * @param orderCode
     * @return
     * @throws BizException
     */
    UserOrderDetailDTO getUserOrderDetail(String orderCode) throws BizException;

    /**
     * 后台获取订单状态下的订单数量
     * @param param
     * @return
     * @throws BizException
     */
    List<OrderStatusCountDTO> backGroundGetStatusCount(OrderStatusCountParam param) throws BizException;

    /**
     * 获取子订单信息列表
     * @param orderCode
     * @param orderSortList
     * @return
     * @throws BizException
     */
    List<SubOrderGoodsDTO> getSubOrderList(String orderCode, List<Long> orderSortList) throws BizException;

    /**
     * 根据订单号查询主订单状态
     * @param orderCodeList
     * @return
     * @throws BizException
     */
    List<OrderStatusDTO> getOrderStatusByOrderCodeList(List<String> orderCodeList) throws BizException;

}