package cn.com.duiba.cloud.order.center.api.model.param.order;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @Description 商品信息
 * @Author dangcang
 * @Date 2021/11/10 2:02 下午
 **/
@Data
public class GoodsParam implements Serializable {

    private static final long serialVersionUID = -3367088637140958493L;

    /**
     * skuId
     */
    private Long skuId;

    /**
     * 商品所有者用户id
     */
    private Long ownId;

    /**
     * 商品所有者用户类型
     */
    private Integer ownType;

    /**
     * 商品类型
     * @see cn.com.duiba.cloud.duiba.goods.center.api.constant.SpuTypeEnum
     */
    private Integer goodsType;

    /**
     * 商品快照id
     */
    private String snapshotId;

    /**
     * 商品名称
     */
    private String goodsName;

    /**
     * 销售价格 分
     */
    private Long salePrice;

    /**
     * 购买数量
     */
    private Long saleNumber;

    /**
     * 备注
     */
    private String remark;

    /**
     * 优惠相关
     */
    private List<DiscountParam> discountParams;

    /**
     * 支付相关
     */
    private List<PaymentParam> paymentParams;

}