package cn.com.duiba.cloud.physical.goods.service.api.enums;

import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * @Description 快递轨迹-快递公司编号枚举类
 * @Author dangcang
 * @Date 2021/11/18 10:49 上午
 **/
@Getter
public enum ExpressCodeEnum {

    ZHONGTONG("zhongtong","中通快递"),
    YUNDA("yunda","韵达快递"),
    YUANTONG("yuantong","圆通速递"),
    SHENTONG("shentong","申通快递"),
    HUITONGKUAIDI("huitongkuaidi","百世汇通"),
    YOUZHENGGUONEI("youzhengguonei","邮政快递包裹"),
    SHUNFENG("shunfeng","顺丰速运"),
    JD("jd","京东快递"),
    TIANTIAN("tiantian", "天天快递"),
    EMS("ems","EMS"),
    YOUZHENGBK("youzhengbk","EMS经济快递"),
    JTEXPRESS("jtexpress","极兔速递"),
    ZHAIJISONG("zhaijisong","宅急送"),
    DEBANGWULIU("debangwuliu","德邦物流"),
    DEBANGKUAIDI("debangkuaidi","德邦快递"),
    ZHONGTONGKUAIYUN("zhongtongkuaiyun","中通快运"),
    BAISHIWULIU("baishiwuliu","百世快运"),
    YOUSHUWULIU("youshuwuliu","优速快递"),
    ANNENGWULIU("annengwuliu","安能快递"),
    KUAIJIESUDI("kuaijiesudi","快捷速递"),

    ;

    private String code;

    private String desc;

    ExpressCodeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static Map<String, ExpressCodeEnum> map = new HashMap<String, ExpressCodeEnum>() {{
        for (ExpressCodeEnum expressCodeEnum : ExpressCodeEnum.values()) {
            put(expressCodeEnum.getCode(), expressCodeEnum);
        }
    }};

    public static ExpressCodeEnum getByCode(String code) {
        return map.get(code);
    }
}