package cn.com.duiba.cloud.physical.goods.service.api.model.param;

import cn.com.duiba.wolf.entity.PageRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;

/**
 * @Description 请描述类的业务用途
 * @Author dangcang
 * @Date 2021/11/11 11:27 上午
 **/
@Data
@EqualsAndHashCode(callSuper=true)
public class BatchTaskQueryParam extends PageRequest implements Serializable {

    private static final long serialVersionUID = -248222680639660802L;
    /**
     * 批量任务id
     */
    private Long batchTaskId;

    /**
     * 操作人id
     */
    private String operatorName;

    /**
     * 任务类型
     * @see cn.com.duiba.cloud.physical.goods.service.api.enums.BatchTypeEnum
     */
    private Integer batchTaskType;

    /**
     * 开始时间 毫秒级时间戳
     */
    private Date startTime;

    /**
     * 截止时间 毫秒级时间戳
     */
    private Date endTime;

}