package cn.com.duiba.cloud.physical.goods.service.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.physical.goods.service.api.model.dto.DispatchBillDTO;
import cn.com.duiba.cloud.physical.goods.service.api.model.dto.ExpressDetailDTO;
import cn.com.duiba.cloud.physical.goods.service.api.model.param.LogisticsMsgParam;

import java.util.List;
import java.util.Map;

/**
 * @Description 物流、发货读相关
 * @Author dangcang
 * @Date 2021/11/14 10:00 上午
 **/
@AdvancedFeignClient
public interface RemoteLogisticsReadService {

    /**
     * 物流轨迹查询-单条
     * @param param
     * @return
     * @throws BizException
     */
    List<ExpressDetailDTO> logisticsInfoQuery(LogisticsMsgParam param) throws BizException;

    /**
     * 获取发货单详情
     * key = orderCode
     * value = 订单下的发货单信息
     * @param params
     * @return
     * @throws BizException
     */
    Map<String, List<DispatchBillDTO>> batchGetDispatchBill(List<LogisticsMsgParam> params) throws BizException;

    /**
     * 获取子订单快递详情
     * @param orderCode
     * @param orderSort
     * @return
     * @throws BizException
     */
    DispatchBillDTO getSubDispatchBill(String orderCode, Integer orderSort) throws BizException;
}