package cn.com.duiba.cloud.physical.goods.service.api.enums;

import lombok.Getter;

/**
 * @Description 发货单状态枚举类
 * @Author dangcang
 * @Date 2021/11/8 6:41 下午
 **/
@Getter
public enum DispatchBillStatusEnum {

    PENDING(1, "待处理"),
    DELIVERED(2,"已发货"),
    CANCELED(3, "已取消"),
    ;

    private Integer status;

    private String desc;

    DispatchBillStatusEnum(Integer status, String desc) {
        this.status = status;
        this.desc = desc;
    }
}