package cn.com.duiba.cloud.physical.goods.service.api.model.dto;

import lombok.Data;

import java.io.Serializable;

/**
 * @Description 请描述类的业务用途
 * @Author dangcang
 * @Date 2021/11/11 11:30 上午
 **/
@Data
public class BatchTaskDTO implements Serializable {

    private static final long serialVersionUID = -5999994968283708842L;
    /**
     * 批量任务id
     */
    private Long batchTaskId;

    /**
     * 操作人id
     */
    private Long operatorId;

    /**
     * 操作人名称
     */
    private String operatorName;

    /**
     * 操作时间
     */
    private Long operatorTime;

    /**
     * 批量任务id
     * @see cn.com.duiba.cloud.physical.goods.service.api.enums.BatchTypeEnum
     */
    private Integer batchType;

    /**
     * 批量数量
     */
    private Long batchNum;

    /**
     * 成功数量
     */
    private Long successNum;

    /**
     * 任务处理状态
     * @see cn.com.duiba.cloud.physical.goods.service.api.enums.BatchStatusEnum
     */
    private Integer batchStatus;

    /**
     * 文件地址
     */
    private String filePath;

    /**
     * 结果文件
     */
    private String resultPath;

    /**
     * 销售人id
     */
    private Long sellerId;

    /**
     * 销售人类型
     */
    private Integer sellerType;

    /**
     * 应用id
     */
    private Long appId;

}