package cn.com.duiba.duiba.qutui.center.api.result;

import java.io.Serializable;

/**
 * @author linzhou
 * @version 1.0.0
 * @ClassName RemoteResult.java
 * @Description quTui返回类
 * @createTime 2021年03月16日 17:49:00
 */
public class QuTuiResult<T> implements Serializable {
    private Boolean success;
    private String code;
    private String message;
    private T data;

    private QuTuiResult(boolean success, T data, String message) {
        this.success = success;
        this.message = message;
        this.data = data;
    }

    private QuTuiResult(Boolean success, String code, String message, T data) {
        this.success = success;
        this.code = code;
        this.message = message;
        this.data = data;
    }

    public static <T> QuTuiResult<T> success() {
        return new QuTuiResult(true,null,null);
    }

    public static <T> QuTuiResult<T> success(T data) {
        return new QuTuiResult(true,data,null);
    }

    public static <T> QuTuiResult<T> fail(String message){
        return new QuTuiResult(false,null,message);
    }

    public static <T> QuTuiResult<T> fail(String code,String message){
        return new QuTuiResult(false,code,message,null);
    }

    public boolean isSuccess() {
        return success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public T getData() {
        return data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public Boolean getSuccess() {
        return success;
    }

    public void setSuccess(Boolean success) {
        this.success = success;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
}
