package cn.com.duiba.duiba.qutui.center.api.dto.setup;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
* 机构表
* 2021-3-16 15:34:08
*/
@Data
public class SetupDto implements Serializable {

    /**
    * 创建者id
    */
    private Long createId;

    /**
    * 上级机构id（母公司为0），建立普通索引
    */
    private Long fatherSetupId;

    /**
     * 上级机构编码
     */
    private String fatherSetupNum;

    /**
    * 创建时间
    */
    private Date gmtCreate;

    /**
    * 修改时间
    */
    private Date gmtModified;

    /**
    * 机构id,主键，自增
    */
    private Long id;

    /**
    * 修改者id
    */
    private Long modifiedId;

    /**
    * 母公司id
    */
    private Long parentSetupId;
    /**
     * 母公司名称
     */
    private String parentSetupName;

    /**
    * 机构等级
    */
    private Integer setupLevel;

    /**
    * 机构名称（不允许为空）
    */
    private String setupName;

    /**
    * 机构编码
    */
    private String setupNum;

    /**
    * 机构状态，0：未激活 1：正常 2：异常
    */
    private Integer setupStatus;


}

