package cn.com.duiba.duiba.qutui.center.api.dto.task;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.duiba.qutui.center.api.exception.ErrorCode;
import cn.com.duiba.duiba.qutui.center.api.util.Assert;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 项目与事件的关联关系
 * 2021-3-16 15:36:54
 */
@Data
public class ProjectEventDto implements Serializable {

    /**
     * 创建者id
     */
    private Long createId;

    /**
     * 事件id
     */
    private Long eventId;

    private String eventName;

    /**
     * 关联状态0：释放 1：关联
     */
    private Integer eventStatus;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 业绩计算说明
     */
    private String gradeExplain;

    /**
     * 业绩计算系数
     */
    private String gradeRatio;

    /**
     * id,主键，自增
     */
    private Long id;

    /**
     * 修改者id
     */
    private Long modifiedId;

    /**
     * 项目id
     */
    private Long projectId;

    /**
     * 是否接收数据0：暂停接收 1：接收数据
     */
    private Integer receiveData;

    /**
     * 机构id
     */
    private Long setupId;

    /**
     * 统计编码
     */
    private String statisticsNum;


    public void check() throws BizException {
        Assert.isNotNull(eventId, ErrorCode.PARAM_ERROR, "事件id不能为空!");
        Assert.isTrue(Integer.valueOf(gradeRatio) > 0, ErrorCode.PARAM_ERROR, "业绩计算系数格式错误");
        Assert.isNotNull(receiveData, ErrorCode.PARAM_ERROR, "请选择是否接收数据");
        Assert.isNotBlank(gradeExplain, ErrorCode.PARAM_ERROR, "请输入业绩计算说明");
    }

    public Integer getInt4Str(String str) {
        try {
            return Integer.parseInt(str);
        } catch (NumberFormatException e) {

        }
        return 0;
    }

}

