package cn.com.duiba.duiba.qutui.center.api.enums;


import org.apache.commons.lang.StringUtils;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by xiaotian on 2021/03/16.
 */
public enum ContentStateEnum {

    /**
     * 内容上下架状态
     */
    NOT_OPEN(1, "下架"),
    OPEN(2, "上架")
    ;

    private Integer code;
    private String desc;

    ContentStateEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, ContentStateEnum> ENUM_MAP = new HashMap<>();

    static {
        for (ContentStateEnum type : values()) {
            ENUM_MAP.put(type.getCode(), type);
        }
    }

    public static ContentStateEnum getByCode(String code) {
        ContentStateEnum result = ENUM_MAP.get(code);
        if (result == null) {
            return null;
        }
        return result;
    }




}
